package gov.va.genisis2.dao.impl;

import static org.junit.Assert.*;

import java.util.List;

import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import gov.va.genisis2.AbstractMockMvcTests;
import gov.va.genisis2.common.enums.UserStatusEnum;
import gov.va.genisis2.dao.IUserManagementDao;
import gov.va.genisis2.exceptions.GenisisDAOException;
import gov.va.genisis2.exceptions.GenisisServiceException;
import gov.va.genisis2.model.User;
import gov.va.genisis2.model.UserCount;
import gov.va.genisis2.service.impl.UserManagementService;
import gov.va.genisis2.util.DateUtil;
import gov.va.genisis2.util.Helper;

/**
 * The Class UserManagementDaoTest.
 *
 * @author Janet Lopez
 * @author Getaneh Kassahun
 * 
 *         The Class UserManagementDaoTest.
 * 
 *         Description: In this UserManagementDaoTest Class which extends the
 *         abstract class, AbstractMockMvcTests, junit tests are defined.
 */
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class UserManagementDaoTest extends AbstractMockMvcTests {

	/** The LOGGER. */
	private static final Logger LOGGER = LoggerFactory.getLogger(UserManagementDaoTest.class);

	/** The users. */
	private User users;

	/** The userManagementDao. */
	@Autowired
	private IUserManagementDao userManagementDao;
	
	private UserManagementDao userManagementDao_SF_NULL;

	/**
	 * Test get user details by email.
	 * 
	 * @throws GenisisDAOException
	 */
	@Test
	public void testGetUserDetailsByEmail() throws GenisisDAOException {

		LOGGER.info("**********Junit Get User Details By Email**********");

		users = userManagementDao.getUserDetailsByEmail("genisisad@gmail.com");
		assertNotNull(users);

	}
	
	/**
	 * Test get user details by email.
	 * 
	 * @throws GenisisDAOException
	 */
	@Test(expected = GenisisDAOException.class)
	public void testGetUserDetailsByEmail_SF_Null() throws GenisisDAOException {

		LOGGER.info("**********Junit Get User Details By Email**********");
		setSessionFactory_Null();
		userManagementDao_SF_NULL.getUserDetailsByEmail("genisisad@gmail.com");
		

	}

	/**
	 * Test get User Details By Id.
	 * 
	 * @throws GenisisDAOException
	 */
	@Test
	public void testGetUserDetailsById() throws GenisisDAOException {

		LOGGER.info("**********Junit Get User Details By Id**********");
		users = userManagementDao.getUserDetailsById(1);
		assertNotNull(users);

	}
	
	/**
	 * Test get User Details By Id.
	 * 
	 * @throws GenisisDAOException
	 */
	@Test(expected = GenisisDAOException.class)
	public void testGetUserDetailsById_SF_NULL() throws GenisisDAOException {

		LOGGER.info("**********Junit Get User Details By Id**********");
		setSessionFactory_Null();
		userManagementDao_SF_NULL.getUserDetailsById(1);

	}


	/**
	 * Test get User Role.
	 * 
	 * @throws GenisisDAOException
	 */

/*	@Test
	public void testGetUserRole() throws GenisisDAOException {

		LOGGER.info("**********Junit Get  User Role**********");
		String userRole = userManagementDao.getUserRole(1);
		assertNotNull(userRole);

	}*/
	
	/**
	 * Test get User Role.
	 * 
	 * @throws GenisisDAOException
	 */

	@Test(expected = GenisisDAOException.class)
	public void testGetUserRole_SF_NULL() throws GenisisDAOException {

		LOGGER.info("**********Junit Get  User Role**********");
		setSessionFactory_Null();
		userManagementDao_SF_NULL.getUserRole(1);

	}

	/**
	 * Test get UserDetailsByUsername.
	 * 
	 * @throws GenisisDAOException
	 */

	@Test
	public void testGetUserDetailsByUsername() throws GenisisDAOException {

		LOGGER.info("**********Junit Get UserDetailsByUsername**********");
		users = userManagementDao.getUserDetailsByUsername("DNS   FRANCISS");
		assertEquals("DNS   FRANCISS", users.getUsername());

	}
	
	/**
	 * Test get UserDetailsByUsername.
	 * 
	 * @throws GenisisDAOException
	 */
	
	@Test(expected = GenisisDAOException.class)
	public void testGetUserDetailsByUsername_SF_NULL() throws GenisisDAOException {

		LOGGER.info("**********Junit Get UserDetailsByUsername**********");
		setSessionFactory_Null();
		userManagementDao_SF_NULL.getUserDetailsByUsername("DNS   FRANCISS");

	}

	/**
	 * Test getUserCountOnRole.
	 * 
	 * @throws GenisisDAOException
	 */

	@Test
	public void testGetUserCountOnRole() throws GenisisDAOException {

		LOGGER.info("**********Junit test Get UserCountOnRole**********");
		List<UserCount> listUserCount = userManagementDao.getUserCountOnRole();
		assertNotNull(listUserCount);

	}
	
	/**
	 * Test getUserCountOnRole.
	 * 
	 * @throws GenisisDAOException
	 */

	@Test(expected = GenisisDAOException.class)
	public void testGetUserCountOnRole_SF_NULL() throws GenisisDAOException {

		LOGGER.info("**********Junit test Get UserCountOnRole**********");
		setSessionFactory_Null();
		userManagementDao_SF_NULL.getUserCountOnRole();

	}

	/**
	 * Test getUserDetailsByRoleTypeId.
	 * 
	 * @throws GenisisDAOException
	 */

	@Test
	public void getUserDetailsByRoleTypeId() throws GenisisDAOException {

		LOGGER.info("**********Junit test Get getUsersList**********");
		List<User> listUserCount = userManagementDao.getUserDetailsByRoleTypeId(2);
		assertNotNull(listUserCount);

	}
	
	/**
	 * Test getUserDetailsByRoleTypeId.
	 * 
	 * @throws GenisisDAOException
	 */

	@Test(expected = GenisisDAOException.class)
	public void getUserDetailsByRoleTypeId_SF_NULL() throws GenisisDAOException {

		LOGGER.info("**********Junit test Get getUsersList**********");
		setSessionFactory_Null();
		userManagementDao_SF_NULL.getUserDetailsByRoleTypeId(2);

	}
	
	/**
	 * Test getAllUsers.
	 * 
	 * @throws GenisisDAOException
	 */

	@Test
	public void testGetAllUsers() throws GenisisDAOException {

		LOGGER.info("**********Junit test Get getAllUsers**********");
		List<User> listUser = userManagementDao.getAllUsers();
		assertNotNull(listUser);

	}
	
	/**
	 * Test getAllUsers.
	 * 
	 * @throws GenisisDAOException
	 */

	@Test(expected = GenisisDAOException.class)
	public void getAllUsers_SF_NULL() throws GenisisDAOException {

		LOGGER.info("**********Junit test Get All Users**********");
		setSessionFactory_Null();
		userManagementDao_SF_NULL.getAllUsers();

	}
	
	/**
	 * Test saveOrUpdate.
	 * 
	 * @throws GenisisDAOException
	 */

	@Test(expected = GenisisDAOException.class)
	public void testSaveOrUpdate_Null() throws GenisisDAOException {

		LOGGER.info("**********Junit test Get saveOrUpdate**********");
		userManagementDao.saveOrUpdate(null);

	}
	
	/**
	 * Test saveOrUpdate.
	 * 
	 * @throws GenisisDAOException
	 */

	@Test
	public void testSaveOrUpdate() throws GenisisDAOException {
		
		LOGGER.info("**********Junit test Get saveOrUpdate**********");
		User user2 = userManagementDao.saveOrUpdate(Helper.getUserLdap());
		assertNotNull(user2);

	}
	
	/**
	 * Test SaveOrUpdate.
	 * 
	 * @throws GenisisDAOException
	 */

	@Test(expected = GenisisDAOException.class)
	public void saveOrUpdate_SF_NULL() throws GenisisDAOException {

		LOGGER.info("**********Junit test SaveOrUpdate**********");
		setSessionFactory_Null();
		userManagementDao_SF_NULL.saveOrUpdate(new User());

	}
	
	
	private void setSessionFactory_Null() {
		userManagementDao_SF_NULL = new UserManagementDao();
		userManagementDao_SF_NULL.setSessionFactory(null);
	}

}
